/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWCheckWorkflowNameDialog
extends VWModalDialog
implements ActionListener,
IVWDialogButtonsActionListener,
DocumentListener,
ListSelectionListener {
    private JLabel messageLabel = null;
    private JLabel m_userLabel = null;
    private JLabel m_dateLabel = null;
    private JRadioButton m_useThisRadioButton = null;
    private JRadioButton m_useAnotherRadioButton = null;
    private JTextField m_typeAheadTextField = null;
    private JList m_wfNameListBox = null;
    private VWDialogButtons m_dialogButtons = null;
    private VWSessionInfo m_sessionInfo = null;
    private String m_workflowName = null;

    public VWCheckWorkflowNameDialog(VWSessionInfo sessionInfo, String workflowName) {
        super(sessionInfo.getParentFrame());
        this.m_sessionInfo = sessionInfo;
        this.m_workflowName = workflowName;
        Dimension dim = VWStringUtils.stringToDimension("445,335");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(new Dimension(300, 200));
        }
        this.setTitle(VWResource.s_checkWorkflowName);
        this.createControls();
        this.initControlsValue();
        this.isExist(this.m_workflowName);
    }

    public boolean isExist(String workflowName) {
        boolean bFound = false;
        boolean bEmpty = false;
        this.m_workflowName = workflowName;
        try {
            String msg;
            if (workflowName == null || VWStringUtils.compare(workflowName, "") == 0) {
                bEmpty = true;
            } else {
                VWSortedListModel listModel = (VWSortedListModel)this.m_wfNameListBox.getModel();
                int size = listModel.size();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        String name = listModel.getElementAt(i).toString();
                        if (VWStringUtils.compare(name, workflowName) != 0) continue;
                        bFound = true;
                        break;
                    }
                }
            }
            if (bFound) {
                VWWorkflowSignature wfSignature;
                VWSession session;
                msg = VWResource.s_workflowNameIsInUse.toString(workflowName);
                this.messageLabel.setText(msg);
                if (this.m_sessionInfo != null && (session = this.m_sessionInfo.getSession()) != null && (wfSignature = session.fetchWorkflowSignature(workflowName)) != null) {
                    String userName = wfSignature.getTransferUserName();
                    DateFormat formatter = DateFormat.getDateTimeInstance(2, 2);
                    String dateTimeString = formatter.format(wfSignature.getTransferDateTime());
                    String transferredByString = VWResource.s_transferredByUser.toString(userName);
                    String transferDateTimeString = VWResource.s_transferDate.toString(dateTimeString);
                    this.m_userLabel.setVisible(true);
                    this.m_userLabel.setText(transferredByString);
                    this.m_dateLabel.setVisible(true);
                    this.m_dateLabel.setText(transferDateTimeString);
                }
            } else {
                msg = null;
                if (bEmpty) {
                    msg = VWResource.s_workflowNameIsEmpty;
                    this.m_useThisRadioButton.setEnabled(false);
                    this.m_useAnotherRadioButton.setSelected(true);
                    this.m_typeAheadTextField.setEnabled(true);
                    this.m_wfNameListBox.setEnabled(true);
                    this.m_typeAheadTextField.requestFocus();
                } else {
                    msg = VWResource.s_workflowNameIsAvailable.toString(workflowName);
                }
                this.messageLabel.setText(msg);
                this.m_userLabel.setVisible(false);
                this.m_dateLabel.setVisible(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bFound;
    }

    public String getWorkflowName() {
        return this.m_workflowName;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_useThisRadioButton)) {
            this.m_typeAheadTextField.setEnabled(false);
            this.m_wfNameListBox.setEnabled(false);
        } else if (source.equals(this.m_useAnotherRadioButton)) {
            this.m_typeAheadTextField.setEnabled(true);
            this.m_typeAheadTextField.requestFocus();
            this.m_wfNameListBox.setEnabled(true);
        }
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: {
                this.m_nExitStatus = 0;
                this.setVisible(false);
                break;
            }
            case 2: {
                this.m_nExitStatus = 1;
                this.setVisible(false);
                break;
            }
            case 32: {
                VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh137.htm");
            }
        }
    }

    public void changedUpdate(DocumentEvent event) {
        this.onWorkflowNameUpdated();
    }

    public void insertUpdate(DocumentEvent event) {
        this.onWorkflowNameUpdated();
    }

    public void removeUpdate(DocumentEvent event) {
        this.onWorkflowNameUpdated();
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.m_workflowName = this.m_wfNameListBox.getSelectedValue().toString();
            this.m_typeAheadTextField.getDocument().removeDocumentListener(this);
            this.m_typeAheadTextField.setText(this.m_workflowName);
            this.m_typeAheadTextField.getDocument().addDocumentListener(this);
        }
    }

    private void createControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 21;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(5, 5, 0, 5);
        this.messageLabel = new JLabel();
        this.getContentPane().add((Component)this.messageLabel, gbCons);
        gbCons.anchor = 10;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 5, 0, 5);
        this.m_userLabel = new JLabel();
        this.getContentPane().add((Component)this.m_userLabel, gbCons);
        gbCons.anchor = 10;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 5, 0, 5);
        this.m_dateLabel = new JLabel();
        this.getContentPane().add((Component)this.m_dateLabel, gbCons);
        ButtonGroup buttonGroup = new ButtonGroup();
        gbCons.anchor = 21;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 20, 0, 5);
        this.m_useThisRadioButton = new JRadioButton(VWResource.s_useThisWorkflowNameStr);
        buttonGroup.add(this.m_useThisRadioButton);
        this.m_useThisRadioButton.setSelected(true);
        this.m_useThisRadioButton.addActionListener(this);
        this.getContentPane().add((Component)this.m_useThisRadioButton, gbCons);
        gbCons.anchor = 21;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 20, 0, 5);
        this.m_useAnotherRadioButton = new JRadioButton(VWResource.s_useAnotherWorkflowNameStr);
        buttonGroup.add(this.m_useAnotherRadioButton);
        this.m_useAnotherRadioButton.addActionListener(this);
        this.getContentPane().add((Component)this.m_useAnotherRadioButton, gbCons);
        gbCons.anchor = 21;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 35, 0, 20);
        this.m_typeAheadTextField = new JTextField();
        this.m_typeAheadTextField.getDocument().addDocumentListener(this);
        this.m_typeAheadTextField.setEnabled(false);
        this.getContentPane().add((Component)this.m_typeAheadTextField, gbCons);
        gbCons.anchor = 21;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.insets = new Insets(0, 35, 0, 20);
        this.m_wfNameListBox = new JList(new VWSortedListModel());
        this.m_wfNameListBox.addListSelectionListener(this);
        this.m_wfNameListBox.setEnabled(false);
        this.getContentPane().add((Component)new JScrollPane(this.m_wfNameListBox), gbCons);
        gbCons.anchor = 10;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 5, 5, 5);
        this.m_dialogButtons = new VWDialogButtons(35);
        this.m_dialogButtons.addDialogButtonsActionListener(this);
        this.getContentPane().add((Component)this.m_dialogButtons, gbCons);
    }

    private void initControlsValue() {
        try {
            String[] workflowNames;
            VWSession session;
            if (this.m_sessionInfo != null && (session = this.m_sessionInfo.getSession()) != null && (workflowNames = session.fetchWorkClassNames(false)) != null) {
                this.m_wfNameListBox.removeListSelectionListener(this);
                VWSortedListModel listModel = (VWSortedListModel)this.m_wfNameListBox.getModel();
                listModel.removeAllElements();
                int count = workflowNames.length;
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        listModel.addElement(workflowNames[i]);
                    }
                    listModel.sort();
                    this.m_wfNameListBox.setSelectedIndex(0);
                }
                this.m_wfNameListBox.addListSelectionListener(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onWorkflowNameUpdated() {
        this.m_workflowName = this.m_typeAheadTextField.getText();
        int index = this.returnFirstGreaterIndex(this.m_wfNameListBox, this.m_workflowName, 0);
        this.m_wfNameListBox.ensureIndexIsVisible(index);
        this.m_wfNameListBox.removeListSelectionListener(this);
        this.m_wfNameListBox.setSelectionInterval(index, index);
        this.m_wfNameListBox.addListSelectionListener(this);
    }

    private int returnFirstGreaterIndex(JList theList, String typedName, int nStartingIndex) {
        try {
            int nCurrentIndex = nStartingIndex;
            boolean bFound = false;
            ListModel listModel = theList.getModel();
            if (listModel.getSize() > 0) {
                if (nCurrentIndex != 0 && VWStringUtils.compare(listModel.getElementAt(nCurrentIndex - 1).toString(), typedName) >= 0) {
                    nCurrentIndex = 0;
                }
                while (!bFound && nCurrentIndex < listModel.getSize()) {
                    if (VWStringUtils.compare(listModel.getElementAt(nCurrentIndex).toString(), typedName) >= 0) {
                        bFound = true;
                        continue;
                    }
                    ++nCurrentIndex;
                }
            }
            if (!bFound) {
                --nCurrentIndex;
            }
            return nCurrentIndex;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return nStartingIndex;
        }
    }
}

